<?php
session_start();
require '../config/db.php';

$msg = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'];
    $senha = $_POST['senha'];

    $stmt = $pdo->prepare("SELECT * FROM clientes WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user && password_verify($senha, $user['senha'])) {
        $_SESSION['cliente'] = $user['nome'];
        header("Location: dashboard.php");
        exit;
    } else {
        $msg = "Login inválido!";
    }
}
?>

<?php include '../includes/header.php'; ?>

<div class="container mt-5">
    <h2>Login</h2>
    <?php if ($msg): ?>
        <div class="alert alert-danger"><?= $msg ?></div>
    <?php endif; ?>
    <form method="POST">
        <input class="form-control mb-3" name="email" type="email" placeholder="Email" required>
        <input class="form-control mb-3" name="senha" type="password" placeholder="Senha" required>
        <button class="btn btn-success">Entrar</button>
        <a href="register.php" class="btn btn-link">Criar conta</a>
    </form>
</div>

<?php include '../includes/footer.php'; ?>
